<?php

namespace App\Http\Controllers;

use App\Banner;
use App\Http\Requests\BannerRequest;
use Session;
use Redirect;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;


class BannerController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $banners = Banner::all();
        return view('banner.index', compact('banners'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('banner.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(BannerRequest $request)
    {
        $validation = $request->validate([
            'title' => 'required',
            'subtitle' => 'required',
            'image' => 'required',
            'description' => 'required'
        ]);

        if(Input::hasFile('image')) {
            $this->validate($request, ['image' => 'mimes:jpeg,jpg,png',]);

            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "banners" . "." . $ext;

            $banner = new Banner();
            $banner->title = $request['title'];
            $banner->subtitle = $request['subtitle'];
            $banner->description = $request['description'];
            $banner->banner_status = $request->input(('banner_status'),1);
            $banner->image = 'images/banners/'.$fileLogo;
            $banner->save();

            $folder = public_path().'/images/banners';
            if(!file_exists($folder)){
                mkdir($folder, 0777, true);
                $file_logo->move(public_path().'/images/banners/',$fileLogo);
            }else{
                $file_logo->move(public_path().'/images/banners/',$fileLogo);
            }

            Session::flash('message', 'Banner creado correctamente.');
            return Redirect::to('/banners');
        }else{
            Session::flash('message', 'Banner no creado correctamente.');
            return Redirect::to('/banners');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function show(Banner $banner)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $banner = Banner::find($id);
        return view('banner.edit', compact('banner'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function update(BannerRequest $request, $id)
    {
        $banner = Banner::find($id);

        if(Input::hasFile('image')){
            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "banners" . "." . $ext;

            // Erase image if exists
            $image_path = $banner->image;
            if($image_path != '') {
                if (file_exists(public_path() . '/' . $image_path)) {
                    unlink(public_path() . '/' . $image_path);
                }
            }
            $file_logo->move(public_path().'/images/banners/',$fileLogo);
            $banner->image = 'images/banners/'.$fileLogo;
        }

        $banner->title = $request['title'];
        $banner->subtitle = $request['subtitle'];
        $banner->description = $request['description'];

        $banner->save();

        Session::flash('message','Banner actualizado');
        return Redirect::to('/banners');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Banner  $banner
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $banner = Banner::find($id);
        $fileLogo = $banner->image;
        if(file_exists(public_path().'/'.$fileLogo)){
            unlink(public_path().'/'.$fileLogo);
            Banner::destroy($id);
            Session::flash('message', 'Banner eliminado correctamente.');
        }else{
            Banner::destroy($id);
            Session::flash('message', 'Banner eliminado correctamente.');
        }
    }


    public function changestatus(Request $request)
    {

        $id = $request['id'];
        $banner = Banner::find($id);
        $banner->banner_status = $request ['status'] == 'true' ? 1:0;
        $banner-> update();

        Session::flash('message','Estatus actualizado');
    }
    
}
