<?php

namespace App\Http\Controllers;

use App\CategoryTips;
use App\Tips;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Session;
use Redirect;

class TipsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tips = Tips::all();
        return view('tips.index', compact('tips'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('tips.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validation = $request->validate([
            'title' => 'required',
            'image' => 'required',
            'description' => 'required'
        ]);

        if(Input::hasFile('image')) {
            $this->validate($request, ['image' => 'mimes:jpeg,jpg,png',]);

            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "tips" . "." . $ext;

            $tip = new Tips();
            $tip->title = $request['title'];
         //   $tip->subtitle = $request['subtitle'];
            $tip->description = $request['description'];
          //  $tip->continent_id =  $continent_id;
            $tip->image = 'images/tips/'.$fileLogo;
            $tip->save();

            $folder = public_path().'/images/tips';
            if(!file_exists($folder)){
                mkdir($folder, 0777, true);
                $file_logo->move(public_path().'/images/tips/',$fileLogo);
            }else{
                $file_logo->move(public_path().'/images/tips/',$fileLogo);
            }

            Session::flash('message', 'Tip de viaje creado correctamente.');
            return Redirect::to('/tips');
          //  return redirect()->route('tips', ['continent' => $continent_id]);
        }else{
            Session::flash('error', 'Ocurrió un error al guardar.');
            return Redirect::to('/tips');
           // return redirect()->route('tips', ['continent' => $continent_id]);

        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Tips  $tips
     * @return \Illuminate\Http\Response
     */
    public function show(Tips $tips)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Tips  $tips
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tip = Tips::find($id);
        return view('tips.edit', compact('tip'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Tips  $tips
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $tip = Tips::find($id);

        if(Input::hasFile('image')){
            $file_logo = Input::file('image');
            $ext = $file_logo->getClientOriginalExtension();
            $fileLogo = time() . "_" . "tips" . "." . $ext;

            // Erase image if exists
            $image_path = $tip->image;
            if($image_path != '') {
                if (file_exists(public_path() . '/' . $image_path)) {
                    unlink(public_path() . '/' . $image_path);
                }
            }
            $file_logo->move(public_path().'/images/tips/',$fileLogo);
            $tip->image = 'images/tips/'.$fileLogo;
        }

        $tip->title = $request['title'];
      //  $tip->subtitle = $request['subtitle'];
        $tip->description = $request['description'];
        $tip->save();

        Session::flash('message','Tip actualizado');
      //  return redirect()->route('tips', ['continent' => $request['continent_id']]);
        return Redirect::to('/tips');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Tips  $tips
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tip = Tips::find($id);
        $fileLogo = $tip->image;

        if(file_exists(public_path().'/'.$fileLogo)){
            unlink(public_path().'/'.$fileLogo);
        }
        Tips::destroy($id);
        Session::flash('message', 'Tip de viaje eliminado correctamente.');
    }
}
