<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Package extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'packs';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'title',
        'from',
        'description',
        'image',
        'detail_image',
        'pack_status',
        'category_id',
        'duration'
    ];

    function category(){
        return $this->belongsTo('App\Category');
    }
}
