@extends("layouts.master")
@section("styles")
  {!! Html::style("/assets/css/main.css") !!}
  {!! Html::style("/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.css") !!}
  {!! Html::style("/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput-typeahead.css") !!}
@endsection

@section('breadcrumb')
  <div class="page-bar">
    @include('partials.request')
    <ul class="page-breadcrumb">
      <li>
        <a href="{!!URL::to('/')!!}">Inicio</a>
        <i class="fa fa-circle"></i>
      </li>
      <li>
        <a href="{!!URL::to('/packages')!!}">Paquetes</a>
        <i class="fa fa-circle"></i>
      </li>
      <li>
        <a href="{!!URL::to('/packages/show')!!}">Detalle paquete</a>
      </li>
    </ul>
  </div>
@endsection

@section("page-content")
  <div class="row content_container">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light portlet-fit bordered">
        <div class="portlet-title">
          {{--<div class="caption">
            <span class="caption-subject bold">Detalle paquete</span>
          </div>--}}
          <div class="col-md-6"> <span class="caption-subject bold" style="font-size: 16px; color:gray">Detalle paquete</span></div>
          <div class="col-md-6">
            <div class="btn-group pull-right">
              <a href="{{URL::route('packages.index')}}" class="btn green"><i class="fa fa-angle-left"></i> Regresar </a>
            </div>
          </div>
        </div>
        <div class="portlet-body" >
          <div class="row">
            <div class="col-md-12">
              <table id="user" class="table table-bordered table-striped">
                <tbody>
                <tr>
                  <td style="width:20%"> Título </td>
                  <td style="width:80%"> {{ $pack->title }}</td>
                </tr>
                <tr>
                  <td> Desde </td>
                  <td> {{ $pack->from }} </td>
                </tr>
                <tr>
                  <td > Ciudades / Hotel </td>
                  <td> {{ $pack->cities }}</td>
                </tr>
                <tr>
                  <td> Duración </td>
                  <td>{{ $pack->duration }}</td>
                </tr>
                <tr>
                  <td> Categoría </td>
                  <td>{{ $pack->category->name }}</td>
                </tr>
                <tr>
                  <td> Descripción </td>
                  <td> {{ $pack->description }} </td>
                </tr>
                <tr>
                  <td> Imagen Portada</td>
                  <td>
                    <img height="400" src="/{{ $pack->image }}" alt="imagen paquete">
                  </td>
                </tr>
                <tr>
                  <td> Imagen Detalle</td>
                  <td>
                    <img height="400" src="/{{ $pack->detail_image }}" alt="imagen paquete detalle">
                  </td>
                </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
@endsection
@section("scripts")
  {!! Html::script("/assets/global/plugins/bootstrap-tagsinput/bootstrap-tagsinput.min.js") !!}
  {!! Html::script("/assets/global/plugins/typeahead/handlebars.min.js") !!}
  {!! Html::script("/assets/global/plugins/typeahead/typeahead.bundle.min.js") !!}
  {!! Html::script("/assets/pages/scripts/components-bootstrap-select.min.js") !!}
  {!! Html::script("/assets/pages/scripts/components-bootstrap-tagsinput.min.js") !!}
  <script type="application/javascript">
    $(document).ready(function(){
      $("#liPack").addClass("active");
    });
  </script>
@endsection
