<?php $__env->startSection("styles"); ?>
  <?php echo Html::style("/assets/global/plugins/datatables/datatables.min.css"); ?>

  <?php echo Html::style("/assets/css/main.css"); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
  <div class="page-bar">
  <?php echo $__env->make('partials.message', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <ul class="page-breadcrumb">
      <li>
        <a href="<?php echo URL::to('/'); ?>">Inicio</a>
        <i class="fa fa-circle"></i>
      </li>
      <li>
        <a href="<?php echo URL::to('/banners'); ?>">Banners</a>
      </li>
    </ul>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("page-content"); ?>
  <div class="row content_container">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light portlet-fit bordered">
        <div class="portlet-title">
          <div class="row">
            <div class="col-md-6"> <span class="caption-subject bold" style="font-size: 16px; color:gray">Banners</span></div>
            <div class="col-md-6">
              <div class="btn-group pull-right">
                <a href="<?php echo e(URL::route('banners.create')); ?>" class="btn green"><i class="fa fa-plus"></i> Nuevo Banner </a>
              </div>
            </div>
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-hover table-bordered" id="sample_editable_1">
            <thead>
            <tr>
              <th class="center">Imagen</th>
              <th class="center">Titulo</th>
              <th class="center">Subtitulo</th>
              <th class="center">Descripción</th>
              <th class="center">Estatus</th>
              <th class="center">Acciones</th>
            </tr>
            </thead>

            <tbody>
            <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td class="center"><img src="<?php echo e($banner->image); ?>" alt="banner" height="75"/></td>
                <td class="center"> <?php echo e($banner->title); ?> </td>
                <td class="center"> <?php echo e($banner->subtitle); ?> </td>
                <td class="center"> <?php echo e($banner->description); ?> </td>
                <td><?php if($banner->banner_status == 1): ?>
                                    <span class="m-badge m-badge--success m-badge--wide"> Activo </span>
                                <?php else: ?>
                                    <span class="m-badge m-badge--info m-badge--wide"> Inactivo </span>
                                <?php endif; ?></td>
                <td>
                  <input type="checkbox" data-toggle="toggle" data-size="sm" data-onstyle="info" class="switch_<?php echo e($banner->id); ?>"  onChange="changestatus(<?php echo e($banner->id); ?>)"
                                    <?php echo e($banner->banner_status == 1 ? 'checked': ''); ?>>
                  <a href="<?php echo e(URL::route('banners.edit', $banner->id)); ?>" title="Editar" class="btn btn-icon-only green-meadow ">
                    <i class="fa fa-edit"></i>
                  </a>
                  <a href="#basic" data-toggle="modal" data-name="<?php echo e($banner->title); ?>" data-id="<?php echo e($banner->id); ?>" title="Eliminar" class="btn btn-icon-only red modalDelete">
                    <i class="fa fa-times"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>

  <div class="modal fade" id="basic" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Eliminar banner</h4>
        </div>
        <div class="modal-body" id="bodyDelete">
        </div>
        <div class="modal-footer">
          <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" id="token">
          <button type="button" class="btn green-meadow" data-dismiss="modal" onclick="deleteUser()">Aceptar</button>
          <button type="button" class="btn red " data-dismiss="modal"></i>Cancelar</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("scripts"); ?>
  <?php echo Html::script("/assets/global/scripts/datatable.js"); ?>

  <?php echo Html::script("/assets/global/plugins/datatables/datatables.min.js"); ?>

  <?php echo Html::script("/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>

  <?php echo Html::script("/assets/scripts/simplified_datatable.js"); ?>

  <script type="application/javascript">
    $(document).ready(function(){
      $("#liBan").addClass("active");
    });

    function  changestatus(bannerid) {
  
      var check = $('.switch_'+bannerid).is(':checked');
            var token = $("#token").val();
            $.ajax({

                url: "/changestatus",
                headers: {'X-CSRF-TOKEN': token},
                type: "POST",
                data:{id:bannerid,status:check},
                success: function(data) {
                    window.location = "/banners";
                  
                }

            });

        }
        
    $(".modalDelete").click(function(){
      id = $(this).data("id");
      var name = $(this).data("name");
      var nodeName=document.createElement("p");
      var nameNode=document.createTextNode("¿Seguro que desea eliminar el banner?");
      nodeName.appendChild(nameNode);
      $("#bodyDelete").empty();
      document.getElementById("bodyDelete").appendChild(nodeName);
    });

    function deleteUser(){
      var token = $("#token").val();

      $.ajax({
        url: "banners/"+id+"",
        headers: {'X-CSRF-TOKEN': token},
        type: "DELETE",
        success: function() {
          window.location = "/banners";
          $("#message").fadeIn();
        }
      });
    }
    
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>